ORG	27695-481

writeregister:
LIDP	64089	# Bei 8192 (12 byte)
LDD		# Erstes Byte von I$: Adresse
EXAB
LIDL	90	# Zweites Byte von I$: Daten bis zu vier Bit
LDD
CALL	blockwrite
RTN

readregister:
LIDP	64089	# Bei 8204 (8 byte)
LDD		# Erstes Byte von I$: Adresse
CALL	blockread	# 65486: Ergebnis
RTN

time:
CALL	setcur	# Bei 8212 (33 byte): Zeigt die Zeit am Cursor an und schreibt TIME$=I$
CALL	setl
ADIM	88
LIA	1	# A Stellencounter bis :
LP	8	# K Adressencounter 5=10er Stunden
ANIM	0
ADIM	5
rp:
CALL	getdata
JRNCP	2	# Wenn letzte Zahl angezeigt, Exit
RTN
DECA		# Wenn schon 2 Zahlen angezeigt, ":" Routine
JRNCM	rp
LIA	58	# : anzeigen
CALL	charout
LIA	1	# Zahlencounter reset
JRM	rp

date:
CALL	setcur	# Bei 8245 (52 byte): Zeigt das Datum am Cursor an und schreibt DATE$=J$
CALL	setl
ADIM	80
LIA	1	# A Stellencounter bis .
LP	8	# K Adressencounter 5=10er Stunden
ANIM	0
ADIM	7
rprp:
CALL	getdata
LP	8
EXAB
LDM
CPIA	9
JRNZP	11	# Wenn letzte Zahl angezeigt, Exit
CALL	dayofweek
LIDP	64087
ADIA	48
STD
RTN
EXAB
DECA		# Wenn schon 2 Zahlen angezeigt, "." Routine
JRNCM	rprp
LIA	46	# : anzeigen
CALL	charout
LIA	1	# Zahlencounter reset
INCK		# neue Adresse setzen
INCK
INCK
INCK
JRM	rprp

writetime:
CALL	setx	# Bei 8297 (20 byte)
ADIM	88	# I$=TIME$ -> Zeit stellen (hhmmss, nicht hh:mm:ss!)
LIA	5
PUSH
EXAB
IXL
SBIA	48
CALL	blockwrite
POP
DECA
JRNCM	11
RTN

writedate:
CALL	setx	# Bei 8317 (52 byte)
ADIM	80	# J$=DATE$ -> Datum stellen (ttmmjjW, nicht tt.mm.jj!)
LIA	1
LP	8
ANIM	0
ADIM	8
rt:
PUSH
DECK
LP	8
LDM
CPIA	14
JRNZP	14
POP
LIDP	64087
LDD
SBIA	48
LIB	12
CALL	blockwrite
RTN
EXAB
IXL
SBIA	48
CALL	blockwrite
POP
DECA
JRNCM	rt
INCK
INCK
INCK
INCK
LIA	1
JRM	rt

readall:
CALL	setx	# Bei 8369 (29 byte)
ADIM	95	# Alle 8 Byte der Uhr nach 64096 (Systemvariable H) lesen
LIA	12
LIB	8
CALL	write
LIA	16
LII	4
IX
PUSH
CALL	reader
POP
DECA
JRNZM	10
CALL	close
RTN

writeall:
CALL	setx	# Bei 8398 (27 byte)
ADIM	95	# Alle 8 Byte der Uhr von 64096 schreiben
LIA	3
LIB	8
CALL	write
LII	16
LIB	4
IXL
CALL	write
DECI
JRNZM	8
CALL	close
RTN

dayofweek:
LIA	12	# Bei 8425 (6 byte) Wochentag 0=Mo bis 6=So in 65486
CALL	blockread
RTN

startclock:
LIB	15	# Bei 8431 (8 byte) Uhr starten
LIA	4
CALL	blockwrite
RTN

stopclock:
LIB	15	# Bei 8439 (8 byte) Uhr anhalten
LIA	6
CALL	blockwrite
RTN

resetclock:
LIB	15	# Bei 8447 (8 byte) Uhr anhalten und reset
LIA	7
CALL	blockwrite
RTN

holdclock:
LIB	13	# Bei 8455 (8 byte) Uhr Daten einfrieren
LIA	3
CALL	blockwrite
RTN

releaseclock:
LIB	13	# Bei 8463 (8 byte) Uhr Daten freischalten
LIA	2
CALL	blockwrite
RTN

#	--- interne Routinen ---

setx:
LP	5	# Setzt X zum Speicher sparen, LX muss nachher angegeben werden
ANIM	0
ADIM	250
LP	4
ANIM	0
RTN

setl:
LP	9
ANIM	0
RTN

getdata:	# Block fr Datum/Zeit-Lesefunktion
PUSH	# Adresse aus K holen
LP	9
LDM
CALL	setx
ADM
LP	8
LDM
CALL	blockread
ADIA	48
IX
STD
INCL
CALL	charout
POP		# 2er Blockcounter zurckholen
DECK		# Adresse --
RTN

setcur:
LP	2	# Cursorposition fr CharOut bertragen
LIDP	&FD09
LII	1
MVWD
LP	2
LIDP	&FD10
EXWD
RTN

charout:	# Gibt das Zeichen in A an DPX/Y aus
LIDP	&FD01
ORID	1
LIDP	&3400
ANID	0
ORID	1
CALL	&615E
LIDP	&3400
ANID	0
STD
LIDP	&FD10	# X Cursor ++
LDD
INCA
STD
RTN

blockwrite:	# B Adresse, A Wert
PUSH
EXAB
PUSH
LIA	3
LIB	4
CALL	write
POP
LIB	4
CALL	write
POP
LIB	4
CALL	write
CALL	close
RTN

blockread:	# A Adresse, A Ergebnis
PUSH
LIA	12
LIB	4
CALL	write
POP
LIB	4
CALL	write
LIDP	65486
LII	4
CALL	reader
CALL	close
RTN

reader:
LIP	93	# Verwendet A, B, I (Counter Anzahl Bits bis 0), [DP] (Ergebnis Bits), BPort
ANID	0
ANIM	128
ORIM	128
OUTB
LIA	1
cyc:
ORIM	64
OUTB
EXAB
INB
ANIM	191
OUTB
ANIA	32
EXAB
JRZP	7
LP	3
MVMD
ORMA
MVDM
LIP	93
SL
DECI
JRNZM	cyc
LDD
RTN

write:
LIP	93	# Verwendet A (Daten zum Schreiben), B (Bitcounter), BPort
ANIM	128
ORIM	128
OUTB
cycle:
SR
JRNCP	5
ORIM	32
JRP	3
ANIM	223
OUTB
ORIM	64
OUTB
ANIM	191
OUTB
DECB
JRNZM	cycle
ANIM	159
OUTB
RTN

close:
LIP	93	# Setzt alle B-Portleitungen auf 0
ANIM	0
OUTB
RTN
