const char DLLVERSIONSTRING[] = "serdll v1.0 by Simon";

// Export Functions

__declspec(dllexport) int getDllVersion(char *version);
__declspec(dllexport) int serOpen (int nComPortNr, int nBaud, int nBits, int nParity, int nStopp);
__declspec(dllexport) int serClose (void);
__declspec(dllexport) int serModeSet (int nBaud, int nBits, int nParity, int nStopp);
__declspec(dllexport) int serSetTimeout (int iTotalReadTimeout);
__declspec(dllexport) int serIsOpen (void);
__declspec(dllexport) int serReadData (char *buffer, int iMaxCount);
__declspec(dllexport) int serSendData (const char *buffer, int iBytesToWrite);
__declspec(dllexport) int serWriteCommByte (int ucByte);
__declspec(dllexport) int serReadCommByte (void);


// Includes
#include <windows.h>
#include <stdio.h>
#include "ser.h"


__declspec(dllexport) int getDllVersion(char *version)
{
	strcpy(version, DLLVERSIONSTRING);
    return 1;
}

__declspec(dllexport) int serOpen (int nComPortNr, int nBaud, int nBits, int nParity, int nStopp)
{
	return ser_Open ( nComPortNr,  nBaud,  nBits,  nParity,  nStopp);
}

__declspec(dllexport) int serClose (void)
{
	return ser_Close();
}

__declspec(dllexport) int serModeSet (int nBaud, int nBits, int nParity, int nStopp)
{
	return ser_ModeSet ( nBaud,  nBits,  nParity,  nStopp);
}

__declspec(dllexport) int serSetTimeout (int iTotalReadTimeout)
{
	return ser_SetTimeout( iTotalReadTimeout);
}

__declspec(dllexport) int serIsOpen (void)
{
	return ser_IsOpen();
}

__declspec(dllexport) int serReadData (char *buffer, int iMaxCount)
{
	return ser_ReadData(buffer,  iMaxCount);
}

__declspec(dllexport) int serSendData (const char *buffer, int iBytesToWrite)
{
	return ser_SendData(buffer, iBytesToWrite);
}

__declspec(dllexport) int serWriteCommByte (int ucByte)
{
	return ser_WriteCommByte((unsigned char)ucByte);
}

__declspec(dllexport) int serReadCommByte (void)
{
	return ser_ReadCommByte();
}
