// C++ Mapper fr Serial.cpp
#include "Serial.h"

extern "C" BOOL ser_Open(int nComPortNr, int nBaud, int nBits, int nParity, int nStopp);
extern "C" BOOL ser_Close (void);
extern "C" BOOL ser_ModeSet (int nBaud, int nBits, int nParity, int nStopp);
extern "C" BOOL ser_SetTimeout (int iTotalReadTimeout);
extern "C" BOOL ser_IsOpen (void);
extern "C" int ser_ReadData (char *buffer, int iMaxCount);
extern "C" int ser_SendData (const char *buffer, int iBytesToWrite);
extern "C" BOOL ser_WriteCommByte (unsigned char ucByte);
extern "C" unsigned char ser_ReadCommByte (void);


CSerial *com1 = new CSerial();


BOOL ser_Open (int nComPortNr, int nBaud, int nBits, int nParity, int nStopp)
{
	return com1->Open(nComPortNr, nBaud, nBits, nParity, nStopp);
}

BOOL ser_Close (void)
{
	return com1->Close();
}

BOOL ser_ModeSet (int nBaud, int nBits, int nParity, int nStopp)
{
	return com1->ModeSet(nBaud, nBits, nParity, nStopp);
}

BOOL ser_SetTimeout (int iTotalReadTimeout)
{
	return com1->SetTimeout(iTotalReadTimeout);
}

BOOL ser_IsOpen (void)
{
	return com1->IsOpen();
}

int ser_ReadData (char *buffer, int iMaxCount)
{
	return com1->ReadData(buffer, iMaxCount);
}

int ser_SendData (const char *buffer, int iBytesToWrite)
{
	return com1->SendData(buffer, iBytesToWrite);
}

BOOL ser_WriteCommByte (unsigned char ucByte)
{
	return com1->WriteCommByte(ucByte);
}

unsigned char ser_ReadCommByte (void)
{
	return com1->ReadCommByte();
}
